/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.PermissionRequirement;
import com.android.tools.lint.checks.RangeConstraint;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UExpression;

class SizeConstraint
extends RangeConstraint {
    final long exact;
    final long min;
    final long max;
    final long multiple;

    public static SizeConstraint create(PsiAnnotation annotation) {
        assert ("android.support.annotation.Size".equals(annotation.getQualifiedName()));
        PsiAnnotationMemberValue exactValue = annotation.findAttributeValue("value");
        PsiAnnotationMemberValue fromValue = annotation.findDeclaredAttributeValue("min");
        PsiAnnotationMemberValue toValue = annotation.findDeclaredAttributeValue("max");
        PsiAnnotationMemberValue multipleValue = annotation.findDeclaredAttributeValue("multiple");
        long exact = SizeConstraint.getLongValue((PsiElement)exactValue, -1L);
        long min = SizeConstraint.getLongValue((PsiElement)fromValue, Long.MIN_VALUE);
        long max = SizeConstraint.getLongValue((PsiElement)toValue, Long.MAX_VALUE);
        long multiple = SizeConstraint.getLongValue((PsiElement)multipleValue, 1L);
        return new SizeConstraint(exact, min, max, multiple);
    }

    public static SizeConstraint create(UAnnotation annotation) {
        assert ("android.support.annotation.Size".equals(annotation.getQualifiedName()));
        long exact = PermissionRequirement.getAnnotationLongValue(annotation, "value", -1L);
        long min = PermissionRequirement.getAnnotationLongValue(annotation, "min", Long.MIN_VALUE);
        long max = PermissionRequirement.getAnnotationLongValue(annotation, "max", Long.MAX_VALUE);
        long multiple = PermissionRequirement.getAnnotationLongValue(annotation, "multiple", 1L);
        return new SizeConstraint(exact, min, max, multiple);
    }

    static SizeConstraint exactly(long value) {
        return new SizeConstraint(value, Long.MIN_VALUE, Long.MAX_VALUE, 1L);
    }

    static SizeConstraint atLeast(long value) {
        return new SizeConstraint(-1L, value, Long.MAX_VALUE, 1L);
    }

    static SizeConstraint atMost(long value) {
        return new SizeConstraint(-1L, Long.MIN_VALUE, value, 1L);
    }

    static SizeConstraint range(long from, long to) {
        return new SizeConstraint(-1L, from, to, 1L);
    }

    static SizeConstraint multiple(int multiple) {
        return new SizeConstraint(-1L, Long.MIN_VALUE, Long.MAX_VALUE, multiple);
    }

    static SizeConstraint rangeWithMultiple(long from, long to, int multiple) {
        return new SizeConstraint(-1L, from, to, multiple);
    }

    static SizeConstraint minWithMultiple(long from, int multiple) {
        return new SizeConstraint(-1L, from, Long.MAX_VALUE, multiple);
    }

    private SizeConstraint(long exact, long min, long max, long multiple) {
        this.exact = exact;
        this.min = min;
        this.max = max;
        this.multiple = multiple;
    }

    public String toString() {
        return this.describe(null);
    }

    public boolean isValid(long actual) {
        return !(this.exact != -1L ? this.exact != actual : actual < this.min || actual > this.max || actual % this.multiple != 0L);
    }

    @Override
    public Boolean isValid(UExpression argument) {
        Number size = this.guessSize(argument);
        if (size == null) {
            return null;
        }
        int actual = size.intValue();
        return this.isValid(actual);
    }

    @Override
    protected Number guessSize(UExpression argument) {
        System.out.println("IMPLEMENT SIZE CONSTRAINT GUESS SIZE");
        return super.guessSize(argument);
    }

    public String describe() {
        return this.describe(null);
    }

    @Override
    public String describe(UExpression argument) {
        return this.describe(argument, null, null);
    }

    public String describe(long argument) {
        return this.describe(null, null, argument);
    }

    public String describe(UExpression argument, String unit, Long actualValue) {
        if (unit == null) {
            unit = argument != null && argument.getExpressionType() != null && argument.getExpressionType().getCanonicalText().equals("java.lang.String") ? "Length" : "Size";
        }
        if (actualValue != null && !this.isValid(actualValue)) {
            long actual = actualValue;
            if (this.exact != -1L) {
                if (this.exact != actual) {
                    return String.format("Expected %1$s %2$d (was %3$d)", unit, this.exact, actual);
                }
            } else {
                if (actual < this.min || actual > this.max) {
                    StringBuilder sb = new StringBuilder(20);
                    if (actual < this.min) {
                        sb.append("Expected ").append(unit).append(" \u2265 ");
                        sb.append(Long.toString(this.min));
                    } else {
                        assert (actual > this.max);
                        sb.append("Expected ").append(unit).append(" \u2264 ");
                        sb.append(Long.toString(this.max));
                    }
                    sb.append(" (was ").append(actual).append(')');
                    return sb.toString();
                }
                if (actual % this.multiple != 0L) {
                    return String.format("Expected %1$s to be a multiple of %2$d (was %3$d and should be either %4$d or %5$d)", unit, this.multiple, actual, actual / this.multiple * this.multiple, (actual / this.multiple + 1L) * this.multiple);
                }
            }
        }
        StringBuilder sb = new StringBuilder(20);
        sb.append(unit);
        sb.append(" must be");
        if (this.exact != -1L) {
            sb.append(" exactly ");
            sb.append(Long.toString(this.exact));
            return sb.toString();
        }
        boolean continued = true;
        if (this.min != Long.MIN_VALUE && this.max != Long.MAX_VALUE) {
            sb.append(" at least ");
            sb.append(Long.toString(this.min));
            sb.append(" and at most ");
            sb.append(Long.toString(this.max));
        } else if (this.min != Long.MIN_VALUE) {
            sb.append(" at least ");
            sb.append(Long.toString(this.min));
        } else if (this.max != Long.MAX_VALUE) {
            sb.append(" at most ");
            sb.append(Long.toString(this.max));
        } else {
            continued = false;
        }
        if (this.multiple != 1L) {
            if (continued) {
                sb.append(" and");
            }
            sb.append(" a multiple of ");
            sb.append(Long.toString(this.multiple));
        }
        if (argument != null) {
            Number actual = this.guessSize(argument);
            if (actual == null) {
                actual = actualValue;
            }
            if (actual != null) {
                sb.append(" (was ").append(Integer.toString(actual.intValue())).append(')');
            }
        } else if (actualValue != null) {
            sb.append(" (was ").append(actualValue).append(')');
        }
        return sb.toString();
    }

    @Override
    public Boolean contains(RangeConstraint other) {
        if (other instanceof SizeConstraint) {
            SizeConstraint otherRange = (SizeConstraint)other;
            if (this.exact != -1L && otherRange.exact != -1L) {
                return this.exact == otherRange.exact;
            }
            if (this.multiple != 1L && (otherRange.exact != -1L ? otherRange.exact % this.multiple != 0L : otherRange.multiple % this.multiple != 0L)) {
                return false;
            }
            if (otherRange.exact != -1L) {
                return otherRange.exact >= this.min && otherRange.exact <= this.max;
            }
            return otherRange.min >= this.min && otherRange.max <= this.max;
        }
        return null;
    }
}

