/*
 * Decompiled with CFR 0.152.
 */
package com.android.fakeadbserver;

import com.android.fakeadbserver.ConnectionHandler;
import com.android.fakeadbserver.DeviceState;
import com.android.fakeadbserver.devicecommandhandlers.DeviceCommandHandler;
import com.android.fakeadbserver.devicecommandhandlers.TrackJdwpCommandHandler;
import com.android.fakeadbserver.hostcommandhandlers.HostCommandHandler;
import com.android.fakeadbserver.hostcommandhandlers.KillCommandHandler;
import com.android.fakeadbserver.hostcommandhandlers.ListDevicesCommandHandler;
import com.android.fakeadbserver.hostcommandhandlers.TrackDevicesCommandHandler;
import com.android.fakeadbserver.shellcommandhandlers.GetPropCommandHandler;
import com.android.fakeadbserver.shellcommandhandlers.LogcatCommandHandler;
import com.android.fakeadbserver.shellcommandhandlers.ShellCommandHandler;
import com.android.fakeadbserver.shellcommandhandlers.WriteNoStopCommandHandler;
import com.android.fakeadbserver.statechangehubs.DeviceStateChangeHub;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public final class FakeAdbServer
implements AutoCloseable {
    private final ServerSocket mServerSocket;
    private final Map<String, Supplier<HostCommandHandler>> mHostCommandHandlers = new HashMap<String, Supplier<HostCommandHandler>>();
    private final Map<String, Supplier<DeviceCommandHandler>> mDeviceCommandHandlers = new HashMap<String, Supplier<DeviceCommandHandler>>();
    private final Map<String, Supplier<ShellCommandHandler>> mShellCommandHandlers = new HashMap<String, Supplier<ShellCommandHandler>>();
    private final Map<String, DeviceState> mDevices = new HashMap<String, DeviceState>();
    private final DeviceStateChangeHub mDeviceChangeHub = new DeviceStateChangeHub();
    private final ExecutorService mThreadPoolExecutor = new ThreadPoolExecutor(6, 21, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(Integer.MAX_VALUE), new ThreadFactoryBuilder().setNameFormat("fake-adb-server-connection-pool-%d").build());
    private Future<?> mConnectionHandlerTask = null;
    private ExecutorService mMainServerThreadExecutor = Executors.newSingleThreadExecutor();
    private volatile boolean mServerKeepAccepting = false;

    private FakeAdbServer() throws IOException {
        this.mServerSocket = new ServerSocket();
    }

    public void start() throws IOException {
        assert (this.mConnectionHandlerTask == null);
        this.mServerSocket.bind(new InetSocketAddress(InetAddress.getLoopbackAddress(), 0));
        this.mServerSocket.setReuseAddress(true);
        this.mServerKeepAccepting = true;
        this.mConnectionHandlerTask = this.mThreadPoolExecutor.submit(() -> {
            while (this.mServerKeepAccepting) {
                try {
                    Socket socket = this.mServerSocket.accept();
                    this.mThreadPoolExecutor.submit(new ConnectionHandler(this, socket, this.mHostCommandHandlers, this.mDeviceCommandHandlers, this.mShellCommandHandlers));
                }
                catch (IOException iOException) {}
            }
        });
    }

    public int getPort() {
        return this.mServerSocket.getLocalPort();
    }

    public void awaitServerTermination() throws InterruptedException {
        this.mMainServerThreadExecutor.awaitTermination(Integer.MAX_VALUE, TimeUnit.DAYS);
    }

    public Future<?> stop() {
        return this.mMainServerThreadExecutor.submit(() -> {
            if (!this.mServerKeepAccepting) {
                return;
            }
            this.mServerKeepAccepting = false;
            this.mDeviceChangeHub.stop();
            this.mDevices.forEach((id, device) -> device.stop());
            this.mConnectionHandlerTask.cancel(true);
            try {
                this.mServerSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mThreadPoolExecutor.shutdownNow();
            this.mMainServerThreadExecutor.shutdown();
        });
    }

    @Override
    public void close() throws Exception {
        try {
            this.stop().get();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public DeviceStateChangeHub getDeviceChangeHub() {
        return this.mDeviceChangeHub;
    }

    public Future<DeviceState> connectDevice(String deviceId, String manufacturer, String deviceModel, String release, String sdk, DeviceState.HostConnectionType hostConnectionType) {
        DeviceState device = new DeviceState(this, deviceId, manufacturer, deviceModel, release, sdk, hostConnectionType);
        if (this.mConnectionHandlerTask == null) {
            assert (!this.mDevices.containsKey(deviceId));
            this.mDevices.put(deviceId, device);
            return Futures.immediateFuture(device);
        }
        return this.mMainServerThreadExecutor.submit(() -> {
            assert (!this.mDevices.containsKey(deviceId));
            this.mDevices.put(deviceId, device);
            this.mDeviceChangeHub.deviceListChanged(this.mDevices.values());
            return device;
        });
    }

    public Future<?> disconnectDevice(String deviceId) {
        return this.mMainServerThreadExecutor.submit(() -> {
            assert (this.mDevices.containsKey(deviceId));
            this.mDevices.remove(deviceId);
            this.mDeviceChangeHub.deviceListChanged(this.mDevices.values());
        });
    }

    public Future<List<DeviceState>> getDeviceListCopy() {
        return this.mMainServerThreadExecutor.submit(() -> new ArrayList<DeviceState>(this.mDevices.values()));
    }

    public static final class Builder {
        private final FakeAdbServer mServer = new FakeAdbServer();

        public Builder setHostCommandHandler(String command, Supplier<HostCommandHandler> handlerConstructor) {
            this.mServer.mHostCommandHandlers.put(command, handlerConstructor);
            return this;
        }

        public Builder setDeviceCommandHandler(String command, Supplier<DeviceCommandHandler> handlerConstructor) {
            this.mServer.mDeviceCommandHandlers.put(command, handlerConstructor);
            return this;
        }

        public Builder setShellCommandHandler(String command, Supplier<ShellCommandHandler> handlerConstructor) {
            this.mServer.mShellCommandHandlers.put(command, handlerConstructor);
            return this;
        }

        public Builder installDefaultCommandHandlers() {
            this.setHostCommandHandler("kill", KillCommandHandler::new);
            this.setHostCommandHandler("devices", ListDevicesCommandHandler::new);
            this.setHostCommandHandler("track-devices", TrackDevicesCommandHandler::new);
            this.setDeviceCommandHandler("track-jdwp", TrackJdwpCommandHandler::new);
            this.setShellCommandHandler("logcat", LogcatCommandHandler::new);
            this.setShellCommandHandler("getprop", GetPropCommandHandler::new);
            this.setShellCommandHandler("write-no-stop", WriteNoStopCommandHandler::new);
            return this;
        }

        public FakeAdbServer build() {
            return this.mServer;
        }
    }
}

