/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.SdkConstants;
import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.utils.ILogger;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import java.io.File;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BuildToolInfo {
    public static final int SDK_LEVEL_FOR_MULTIDEX_NATIVE_SUPPORT = 21;
    private final Revision mRevision;
    private final File mPath;
    private final Map<PathId, String> mPaths = Maps.newEnumMap(PathId.class);

    public static BuildToolInfo fromStandardDirectoryLayout(Revision revision, File path) {
        return new BuildToolInfo(revision, path);
    }

    public static BuildToolInfo fromLocalPackage(LocalPackage localPackage) {
        Preconditions.checkNotNull((Object)localPackage, (Object)"localPackage");
        Preconditions.checkArgument((boolean)localPackage.getPath().contains("build-tools"), (String)"%s package required.", (Object)"build-tools");
        return BuildToolInfo.fromStandardDirectoryLayout(localPackage.getVersion(), localPackage.getLocation());
    }

    public static BuildToolInfo modifiedLayout(Revision revision, File mainPath, File aapt, File aidl, File dx, File dxJar, File llmvRsCc, File androidRs, File androidRsClang, File bccCompat, File ldArm, File ldArm64, File ldX86, File ldX86_64, File ldMips, File zipAlign, File aapt2) {
        BuildToolInfo result = new BuildToolInfo(revision, mainPath);
        result.add(PathId.AAPT, aapt);
        result.add(PathId.AIDL, aidl);
        result.add(PathId.DX, dx);
        result.add(PathId.DX_JAR, dxJar);
        result.add(PathId.LLVM_RS_CC, llmvRsCc);
        result.add(PathId.ANDROID_RS, androidRs);
        result.add(PathId.ANDROID_RS_CLANG, androidRsClang);
        result.add(PathId.ZIP_ALIGN, zipAlign);
        if (bccCompat != null) {
            result.add(PathId.BCC_COMPAT, bccCompat);
        } else if (PathId.BCC_COMPAT.isPresentIn(revision)) {
            throw new IllegalArgumentException("BCC_COMPAT required in " + revision.toString());
        }
        if (ldArm != null) {
            result.add(PathId.LD_ARM, ldArm);
        } else if (PathId.LD_ARM.isPresentIn(revision)) {
            throw new IllegalArgumentException("LD_ARM required in " + revision.toString());
        }
        if (ldArm64 != null) {
            result.add(PathId.LD_ARM64, ldArm64);
        } else if (PathId.LD_ARM64.isPresentIn(revision)) {
            throw new IllegalArgumentException("LD_ARM64 required in " + revision.toString());
        }
        if (ldX86 != null) {
            result.add(PathId.LD_X86, ldX86);
        } else if (PathId.LD_X86.isPresentIn(revision)) {
            throw new IllegalArgumentException("LD_X86 required in " + revision.toString());
        }
        if (ldX86_64 != null) {
            result.add(PathId.LD_X86_64, ldX86_64);
        } else if (PathId.LD_X86_64.isPresentIn(revision)) {
            throw new IllegalArgumentException("LD_X86_64 required in " + revision.toString());
        }
        if (ldMips != null) {
            result.add(PathId.LD_MIPS, ldMips);
        } else if (PathId.LD_MIPS.isPresentIn(revision)) {
            throw new IllegalArgumentException("LD_MIPS required in " + revision.toString());
        }
        if (aapt2 != null) {
            result.add(PathId.AAPT2, aapt2);
            result.add(PathId.DAEMON_AAPT2, aapt2);
        } else if (PathId.AAPT2.isPresentIn(revision)) {
            throw new IllegalArgumentException("AAPT2 required in " + revision.toString());
        }
        return result;
    }

    public static BuildToolInfo partial(Revision revision, File location, Map<PathId, File> paths) {
        BuildToolInfo result = new BuildToolInfo(revision, location);
        paths.forEach(result::add);
        return result;
    }

    private BuildToolInfo(Revision revision, File path) {
        this.mRevision = revision;
        this.mPath = path;
        this.add(PathId.AAPT, SdkConstants.FN_AAPT);
        this.add(PathId.AAPT2, SdkConstants.FN_AAPT2);
        this.add(PathId.DAEMON_AAPT2, SdkConstants.FN_AAPT2);
        this.add(PathId.AIDL, SdkConstants.FN_AIDL);
        this.add(PathId.DX, SdkConstants.FN_DX);
        this.add(PathId.DX_JAR, "lib" + File.separator + "dx.jar");
        this.add(PathId.LLVM_RS_CC, SdkConstants.FN_RENDERSCRIPT);
        this.add(PathId.ANDROID_RS, SdkConstants.OS_FRAMEWORK_RS);
        this.add(PathId.ANDROID_RS_CLANG, SdkConstants.OS_FRAMEWORK_RS_CLANG);
        this.add(PathId.DEXDUMP, SdkConstants.FN_DEXDUMP);
        this.add(PathId.BCC_COMPAT, SdkConstants.FN_BCC_COMPAT);
        this.add(PathId.LD_ARM, SdkConstants.FN_LD_ARM);
        this.add(PathId.LD_ARM64, SdkConstants.FN_LD_ARM64);
        this.add(PathId.LD_X86, SdkConstants.FN_LD_X86);
        this.add(PathId.LD_X86_64, SdkConstants.FN_LD_X86_64);
        this.add(PathId.LD_MIPS, SdkConstants.FN_LD_MIPS);
        this.add(PathId.ZIP_ALIGN, SdkConstants.FN_ZIPALIGN);
        this.add(PathId.JACK, "jack.jar");
        this.add(PathId.JILL, "jill.jar");
        this.add(PathId.JACK_JACOCO_REPORTER, "jack-jacoco-reporter.jar");
        this.add(PathId.JACK_COVERAGE_PLUGIN, "jack-coverage-plugin.jar");
        this.add(PathId.SPLIT_SELECT, SdkConstants.FN_SPLIT_SELECT);
    }

    private void add(PathId id, String leaf) {
        this.add(id, new File(this.mPath, leaf));
    }

    private void add(PathId id, File path) {
        String str = path.getAbsolutePath();
        if (path.isDirectory() && str.charAt(str.length() - 1) != File.separatorChar) {
            str = str + File.separatorChar;
        }
        this.mPaths.put(id, str);
    }

    public Revision getRevision() {
        return this.mRevision;
    }

    public File getLocation() {
        return this.mPath;
    }

    public String getPath(PathId pathId) {
        assert (pathId.isPresentIn(this.mRevision));
        return this.mPaths.get((Object)pathId);
    }

    public boolean isValid(ILogger log) {
        for (Map.Entry<PathId, String> entry : this.mPaths.entrySet()) {
            File f = new File(entry.getValue());
            if (f.exists() || !entry.getKey().isPresentIn(this.mRevision)) continue;
            if (log != null) {
                log.warning("Build-tool %1$s is missing %2$s at %3$s", new Object[]{this.mRevision.toString(), entry.getKey(), f.getAbsolutePath()});
            }
            return false;
        }
        return true;
    }

    public JackVersion getSupportedJackApi() {
        for (JackVersion version : JackVersion.values()) {
            if (!version.getSupportedBetween().contains((Comparable)this.getRevision())) continue;
            return version;
        }
        throw new UnsupportedOperationException("Jack API unsupported; update the build tools.");
    }

    static Revision getCurrentJvmVersion() throws NumberFormatException {
        String javav = System.getProperty("java.version");
        Pattern p = Pattern.compile("((\\d+)(\\.\\d+)?(\\.\\d+)?).*");
        Matcher m = p.matcher(javav);
        if (m.matches()) {
            return Revision.parseRevision((String)m.group(1));
        }
        return null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rev", (Object)this.mRevision).add("mPath", (Object)this.mPath).add("mPaths", (Object)this.getPathString()).toString();
    }

    private String getPathString() {
        StringBuilder sb = new StringBuilder("{");
        for (Map.Entry<PathId, String> entry : this.mPaths.entrySet()) {
            if (!entry.getKey().isPresentIn(this.mRevision)) continue;
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append((Object)entry.getKey()).append('=').append(entry.getValue());
        }
        sb.append('}');
        return sb.toString();
    }

    public static enum JackVersion {
        V4(4, "24.0.3");

        private final int version;
        private Range<Revision> supportedBetween;

        private JackVersion(int version, String lowerRevision) {
            this.version = version;
            this.supportedBetween = Range.atLeast((Comparable)Revision.parseRevision((String)lowerRevision));
        }

        private JackVersion(int version, String lowerRevision, String upperRevision) {
            this.version = version;
            this.supportedBetween = Range.closedOpen((Comparable)Revision.parseRevision((String)lowerRevision), (Comparable)Revision.parseRevision((String)upperRevision));
        }

        public int getVersion() {
            return this.version;
        }

        public Revision getMinRevision() {
            return (Revision)this.supportedBetween.lowerEndpoint();
        }

        public Range<Revision> getSupportedBetween() {
            return this.supportedBetween;
        }
    }

    public static enum PathId {
        AAPT("1.0.0"),
        AIDL("1.0.0"),
        DX("1.0.0"),
        DX_JAR("1.0.0"),
        LLVM_RS_CC("1.0.0"),
        ANDROID_RS("1.0.0"),
        ANDROID_RS_CLANG("1.0.0"),
        DEXDUMP("1.0.0"),
        BCC_COMPAT("18.1.0"),
        LD_ARM("18.1.0"),
        LD_X86("18.1.0"),
        LD_MIPS("18.1.0"),
        ZIP_ALIGN("19.1.0"),
        JACK("21.1.0"),
        JILL("21.1.0"),
        SPLIT_SELECT("22.0.0"),
        LD_ARM64("23.0.3"),
        JACK_JACOCO_REPORTER("24.0.0"),
        JACK_COVERAGE_PLUGIN("24.0.0"),
        LD_X86_64("24.0.0"),
        AAPT2("24.0.0 rc2"),
        DAEMON_AAPT2("26.0.1");

        private final Revision mMinRevision;

        private PathId(String minRevision) {
            this.mMinRevision = Revision.parseRevision((String)minRevision);
        }

        public boolean isPresentIn(Revision revision) {
            return revision.compareTo(this.mMinRevision) >= 0;
        }

        public Revision getMinRevision() {
            return this.mMinRevision;
        }
    }
}

