/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.ole.win32;

import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.ole.win32.VARIANT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleAutomation;

public final class Variant {
    public static final int sizeof = VARIANT.sizeof;
    private short type;
    private boolean booleanData;
    private byte byteData;
    private short shortData;
    private char charData;
    private int intData;
    private long longData;
    private float floatData;
    private double doubleData;
    private String stringData;
    private int byRefPtr;
    private IDispatch dispatchData;
    private IUnknown unknownData;

    public static void win32_copy(int n, Variant variant) {
        variant.getData(n);
    }

    public static Variant win32_new(int n) {
        Variant variant = new Variant();
        variant.setData(n);
        return variant;
    }

    public Variant() {
        this.type = 0;
    }

    public Variant(float f) {
        this.type = (short)4;
        this.floatData = f;
    }

    public Variant(double d) {
        this.type = (short)5;
        this.doubleData = d;
    }

    public Variant(int n) {
        this.type = (short)3;
        this.intData = n;
    }

    public Variant(int n, short s) {
        this.type = s;
        this.byRefPtr = n;
    }

    public Variant(OleAutomation oleAutomation) {
        this.type = (short)9;
        this.dispatchData = new IDispatch(oleAutomation.getAddress());
    }

    public Variant(IDispatch iDispatch) {
        this.type = (short)9;
        this.dispatchData = iDispatch;
    }

    public Variant(IUnknown iUnknown) {
        this.type = (short)13;
        this.unknownData = iUnknown;
    }

    public Variant(long l) {
        this.type = (short)20;
        this.longData = l;
    }

    public Variant(String string) {
        this.type = (short)8;
        this.stringData = string;
    }

    public Variant(short s) {
        this.type = (short)2;
        this.shortData = s;
    }

    public Variant(boolean bl) {
        this.type = (short)11;
        this.booleanData = bl;
    }

    public void dispose() {
        if ((this.type & 0x4000) == 16384) {
            return;
        }
        switch (this.type) {
            case 9: {
                this.dispatchData.Release();
                break;
            }
            case 13: {
                this.unknownData.Release();
            }
        }
    }

    public OleAutomation getAutomation() {
        OleAutomation oleAutomation;
        if (this.type == 0) {
            OLE.error(1010, -1);
        }
        if (this.type == 9) {
            return new OleAutomation(this.dispatchData);
        }
        int n = OS.GlobalAlloc(64, sizeof);
        int n2 = OS.GlobalAlloc(64, sizeof);
        try {
            this.getData(n);
            int n3 = COM.VariantChangeType(n2, n, (short)0, (short)9);
            if (n3 != 0) {
                OLE.error(1010, n3);
            }
            Variant variant = new Variant();
            variant.setData(n2);
            oleAutomation = variant.getAutomation();
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            COM.VariantClear(n);
            OS.GlobalFree(n);
            COM.VariantClear(n2);
            OS.GlobalFree(n2);
            throw throwable;
        }
        COM.VariantClear(n);
        OS.GlobalFree(n);
        COM.VariantClear(n2);
        OS.GlobalFree(n2);
        return oleAutomation;
    }

    public IDispatch getDispatch() {
        IDispatch iDispatch;
        if (this.type == 0) {
            OLE.error(1010, -1);
        }
        if (this.type == 9) {
            return this.dispatchData;
        }
        int n = OS.GlobalAlloc(64, sizeof);
        int n2 = OS.GlobalAlloc(64, sizeof);
        try {
            this.getData(n);
            int n3 = COM.VariantChangeType(n2, n, (short)0, (short)9);
            if (n3 != 0) {
                OLE.error(1010, n3);
            }
            Variant variant = new Variant();
            variant.setData(n2);
            iDispatch = variant.getDispatch();
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            COM.VariantClear(n);
            OS.GlobalFree(n);
            COM.VariantClear(n2);
            OS.GlobalFree(n2);
            throw throwable;
        }
        COM.VariantClear(n);
        OS.GlobalFree(n);
        COM.VariantClear(n2);
        OS.GlobalFree(n2);
        return iDispatch;
    }

    public boolean getBoolean() {
        boolean bl;
        if (this.type == 0) {
            OLE.error(1010, -1);
        }
        if (this.type == 11) {
            return this.booleanData;
        }
        int n = OS.GlobalAlloc(64, sizeof);
        int n2 = OS.GlobalAlloc(64, sizeof);
        try {
            this.getData(n);
            int n3 = COM.VariantChangeType(n2, n, (short)0, (short)11);
            if (n3 != 0) {
                OLE.error(1010, n3);
            }
            Variant variant = new Variant();
            variant.setData(n2);
            bl = variant.getBoolean();
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            COM.VariantClear(n);
            OS.GlobalFree(n);
            COM.VariantClear(n2);
            OS.GlobalFree(n2);
            throw throwable;
        }
        COM.VariantClear(n);
        OS.GlobalFree(n);
        COM.VariantClear(n2);
        OS.GlobalFree(n2);
        return bl;
    }

    public int getByRef() {
        if (this.type == 0) {
            OLE.error(1010, -1);
        }
        if ((this.type & 0x4000) == 16384) {
            return this.byRefPtr;
        }
        return 0;
    }

    public byte getByte() {
        byte by;
        if (this.type == 0) {
            OLE.error(1010, -1);
        }
        if (this.type == 16) {
            return this.byteData;
        }
        int n = OS.GlobalAlloc(64, sizeof);
        int n2 = OS.GlobalAlloc(64, sizeof);
        try {
            this.getData(n);
            int n3 = COM.VariantChangeType(n2, n, (short)0, (short)16);
            if (n3 != 0) {
                OLE.error(1010, n3);
            }
            Variant variant = new Variant();
            variant.setData(n2);
            by = variant.getByte();
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            COM.VariantClear(n);
            OS.GlobalFree(n);
            COM.VariantClear(n2);
            OS.GlobalFree(n2);
            throw throwable;
        }
        COM.VariantClear(n);
        OS.GlobalFree(n);
        COM.VariantClear(n2);
        OS.GlobalFree(n2);
        return by;
    }

    public char getChar() {
        char c;
        if (this.type == 0) {
            OLE.error(1010, -1);
        }
        if (this.type == 18) {
            return this.charData;
        }
        int n = OS.GlobalAlloc(64, sizeof);
        int n2 = OS.GlobalAlloc(64, sizeof);
        try {
            this.getData(n);
            int n3 = COM.VariantChangeType(n2, n, (short)0, (short)18);
            if (n3 != 0) {
                OLE.error(1010, n3);
            }
            Variant variant = new Variant();
            variant.setData(n2);
            c = variant.getChar();
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            COM.VariantClear(n);
            OS.GlobalFree(n);
            COM.VariantClear(n2);
            OS.GlobalFree(n2);
            throw throwable;
        }
        COM.VariantClear(n);
        OS.GlobalFree(n);
        COM.VariantClear(n2);
        OS.GlobalFree(n2);
        return c;
    }

    void getData(int n) {
        if (n == 0) {
            OLE.error(1007);
        }
        COM.VariantInit(n);
        if ((this.type & 0x4000) == 16384) {
            COM.MoveMemory(n, new short[]{this.type}, 2);
            COM.MoveMemory(n + 8, new int[]{this.byRefPtr}, OS.PTR_SIZEOF);
            return;
        }
        switch (this.type) {
            case 0: 
            case 1: {
                COM.MoveMemory(n, new short[]{this.type}, 2);
                break;
            }
            case 11: {
                COM.MoveMemory(n, new short[]{this.type}, 2);
                COM.MoveMemory(n + 8, new short[]{this.booleanData ? (short)-1 : 0}, 2);
                break;
            }
            case 16: {
                COM.MoveMemory(n, new short[]{this.type}, 2);
                COM.MoveMemory(n + 8, new byte[]{this.byteData}, 1);
                break;
            }
            case 2: {
                COM.MoveMemory(n, new short[]{this.type}, 2);
                COM.MoveMemory(n + 8, new short[]{this.shortData}, 2);
                break;
            }
            case 18: {
                COM.MoveMemory(n, new short[]{this.type}, 2);
                COM.MoveMemory(n + 8, new char[]{this.charData}, 2);
                break;
            }
            case 3: {
                COM.MoveMemory(n, new short[]{this.type}, 2);
                COM.MoveMemory(n + 8, new int[]{this.intData}, 4);
                break;
            }
            case 20: {
                COM.MoveMemory(n, new short[]{this.type}, 2);
                COM.MoveMemory(n + 8, new long[]{this.longData}, 8);
                break;
            }
            case 4: {
                COM.MoveMemory(n, new short[]{this.type}, 2);
                COM.MoveMemory(n + 8, new float[]{this.floatData}, 4);
                break;
            }
            case 5: {
                COM.MoveMemory(n, new short[]{this.type}, 2);
                COM.MoveMemory(n + 8, new double[]{this.doubleData}, 8);
                break;
            }
            case 9: {
                this.dispatchData.AddRef();
                COM.MoveMemory(n, new short[]{this.type}, 2);
                COM.MoveMemory(n + 8, new int[]{this.dispatchData.getAddress()}, OS.PTR_SIZEOF);
                break;
            }
            case 13: {
                this.unknownData.AddRef();
                COM.MoveMemory(n, new short[]{this.type}, 2);
                COM.MoveMemory(n + 8, new int[]{this.unknownData.getAddress()}, OS.PTR_SIZEOF);
                break;
            }
            case 8: {
                COM.MoveMemory(n, new short[]{this.type}, 2);
                char[] cArray = (String.valueOf(this.stringData) + "\u0000").toCharArray();
                int n2 = COM.SysAllocString(cArray);
                COM.MoveMemory(n + 8, new int[]{n2}, OS.PTR_SIZEOF);
                break;
            }
            default: {
                OLE.error(20);
            }
        }
    }

    public double getDouble() {
        double d;
        if (this.type == 0) {
            OLE.error(1010, -1);
        }
        if (this.type == 5) {
            return this.doubleData;
        }
        int n = OS.GlobalAlloc(64, sizeof);
        int n2 = OS.GlobalAlloc(64, sizeof);
        try {
            this.getData(n);
            int n3 = COM.VariantChangeType(n2, n, (short)0, (short)5);
            if (n3 != 0) {
                OLE.error(1010, n3);
            }
            Variant variant = new Variant();
            variant.setData(n2);
            d = variant.getDouble();
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            COM.VariantClear(n);
            OS.GlobalFree(n);
            COM.VariantClear(n2);
            OS.GlobalFree(n2);
            throw throwable;
        }
        COM.VariantClear(n);
        OS.GlobalFree(n);
        COM.VariantClear(n2);
        OS.GlobalFree(n2);
        return d;
    }

    public float getFloat() {
        float f;
        if (this.type == 0) {
            OLE.error(1010, -1);
        }
        if (this.type == 4) {
            return this.floatData;
        }
        int n = OS.GlobalAlloc(64, sizeof);
        int n2 = OS.GlobalAlloc(64, sizeof);
        try {
            this.getData(n);
            int n3 = COM.VariantChangeType(n2, n, (short)0, (short)4);
            if (n3 != 0) {
                OLE.error(1010, n3);
            }
            Variant variant = new Variant();
            variant.setData(n2);
            f = variant.getFloat();
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            COM.VariantClear(n);
            OS.GlobalFree(n);
            COM.VariantClear(n2);
            OS.GlobalFree(n2);
            throw throwable;
        }
        COM.VariantClear(n);
        OS.GlobalFree(n);
        COM.VariantClear(n2);
        OS.GlobalFree(n2);
        return f;
    }

    public int getInt() {
        int n;
        if (this.type == 0) {
            OLE.error(1010, -1);
        }
        if (this.type == 3) {
            return this.intData;
        }
        int n2 = OS.GlobalAlloc(64, sizeof);
        int n3 = OS.GlobalAlloc(64, sizeof);
        try {
            this.getData(n2);
            int n4 = COM.VariantChangeType(n3, n2, (short)0, (short)3);
            if (n4 != 0) {
                OLE.error(1010, n4);
            }
            Variant variant = new Variant();
            variant.setData(n3);
            n = variant.getInt();
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            COM.VariantClear(n2);
            OS.GlobalFree(n2);
            COM.VariantClear(n3);
            OS.GlobalFree(n3);
            throw throwable;
        }
        COM.VariantClear(n2);
        OS.GlobalFree(n2);
        COM.VariantClear(n3);
        OS.GlobalFree(n3);
        return n;
    }

    public long getLong() {
        long l;
        if (this.type == 0) {
            OLE.error(1010, -1);
        }
        if (this.type == 20) {
            return this.longData;
        }
        int n = OS.GlobalAlloc(64, sizeof);
        int n2 = OS.GlobalAlloc(64, sizeof);
        try {
            this.getData(n);
            int n3 = COM.VariantChangeType(n2, n, (short)0, (short)20);
            if (n3 != 0) {
                OLE.error(1010, n3);
            }
            Variant variant = new Variant();
            variant.setData(n2);
            l = variant.getLong();
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            COM.VariantClear(n);
            OS.GlobalFree(n);
            COM.VariantClear(n2);
            OS.GlobalFree(n2);
            throw throwable;
        }
        COM.VariantClear(n);
        OS.GlobalFree(n);
        COM.VariantClear(n2);
        OS.GlobalFree(n2);
        return l;
    }

    public short getShort() {
        short s;
        if (this.type == 0) {
            OLE.error(1010, -1);
        }
        if (this.type == 2) {
            return this.shortData;
        }
        int n = OS.GlobalAlloc(64, sizeof);
        int n2 = OS.GlobalAlloc(64, sizeof);
        try {
            this.getData(n);
            int n3 = COM.VariantChangeType(n2, n, (short)0, (short)2);
            if (n3 != 0) {
                OLE.error(1010, n3);
            }
            Variant variant = new Variant();
            variant.setData(n2);
            s = variant.getShort();
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            COM.VariantClear(n);
            OS.GlobalFree(n);
            COM.VariantClear(n2);
            OS.GlobalFree(n2);
            throw throwable;
        }
        COM.VariantClear(n);
        OS.GlobalFree(n);
        COM.VariantClear(n2);
        OS.GlobalFree(n2);
        return s;
    }

    public String getString() {
        String string;
        if (this.type == 0) {
            OLE.error(1010, -1);
        }
        if (this.type == 8) {
            return this.stringData;
        }
        int n = OS.GlobalAlloc(64, sizeof);
        int n2 = OS.GlobalAlloc(64, sizeof);
        try {
            this.getData(n);
            int n3 = COM.VariantChangeType(n2, n, (short)0, (short)8);
            if (n3 != 0) {
                OLE.error(1010, n3);
            }
            Variant variant = new Variant();
            variant.setData(n2);
            string = variant.getString();
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            COM.VariantClear(n);
            OS.GlobalFree(n);
            COM.VariantClear(n2);
            OS.GlobalFree(n2);
            throw throwable;
        }
        COM.VariantClear(n);
        OS.GlobalFree(n);
        COM.VariantClear(n2);
        OS.GlobalFree(n2);
        return string;
    }

    public short getType() {
        return this.type;
    }

    public IUnknown getUnknown() {
        IUnknown iUnknown;
        if (this.type == 0) {
            OLE.error(1010, -1);
        }
        if (this.type == 13) {
            return this.unknownData;
        }
        int n = OS.GlobalAlloc(64, sizeof);
        int n2 = OS.GlobalAlloc(64, sizeof);
        try {
            this.getData(n);
            int n3 = COM.VariantChangeType(n2, n, (short)0, (short)13);
            if (n3 != 0) {
                OLE.error(1010, n3);
            }
            Variant variant = new Variant();
            variant.setData(n2);
            iUnknown = variant.getUnknown();
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            COM.VariantClear(n);
            OS.GlobalFree(n);
            COM.VariantClear(n2);
            OS.GlobalFree(n2);
            throw throwable;
        }
        COM.VariantClear(n);
        OS.GlobalFree(n);
        COM.VariantClear(n2);
        OS.GlobalFree(n2);
        return iUnknown;
    }

    public void setByRef(boolean bl) {
        if ((this.type & 0x4000) == 0 || (this.type & 0xB) == 0) {
            OLE.error(1010);
        }
        COM.MoveMemory(this.byRefPtr, new short[]{bl ? (short)-1 : 0}, 2);
    }

    public void setByRef(float f) {
        if ((this.type & 0x4000) == 0 || (this.type & 4) == 0) {
            OLE.error(1010);
        }
        COM.MoveMemory(this.byRefPtr, new float[]{f}, 4);
    }

    public void setByRef(int n) {
        if ((this.type & 0x4000) == 0 || (this.type & 3) == 0) {
            OLE.error(1010);
        }
        COM.MoveMemory(this.byRefPtr, new int[]{n}, OS.PTR_SIZEOF);
    }

    public void setByRef(short s) {
        if ((this.type & 0x4000) == 0 || (this.type & 2) == 0) {
            OLE.error(1010);
        }
        COM.MoveMemory(this.byRefPtr, new short[]{s}, 2);
    }

    void setData(int n) {
        if (n == 0) {
            OLE.error(5);
        }
        short[] sArray = new short[1];
        COM.MoveMemory(sArray, n, 2);
        this.type = sArray[0];
        if ((this.type & 0x4000) == 16384) {
            int[] nArray = new int[1];
            OS.MoveMemory(nArray, n + 8, OS.PTR_SIZEOF);
            this.byRefPtr = nArray[0];
            return;
        }
        switch (this.type) {
            case 0: 
            case 1: {
                break;
            }
            case 11: {
                short[] sArray2 = new short[1];
                COM.MoveMemory(sArray2, n + 8, 2);
                this.booleanData = sArray2[0] != 0;
                break;
            }
            case 16: {
                byte[] byArray = new byte[1];
                COM.MoveMemory(byArray, n + 8, 1);
                this.byteData = byArray[0];
                break;
            }
            case 2: {
                short[] sArray3 = new short[1];
                COM.MoveMemory(sArray3, n + 8, 2);
                this.shortData = sArray3[0];
                break;
            }
            case 18: {
                char[] cArray = new char[1];
                COM.MoveMemory(cArray, n + 8, 2);
                this.charData = cArray[0];
                break;
            }
            case 3: {
                int[] nArray = new int[1];
                OS.MoveMemory(nArray, n + 8, 4);
                this.intData = nArray[0];
                break;
            }
            case 20: {
                long[] lArray = new long[1];
                OS.MoveMemory(lArray, n + 8, 8);
                this.longData = lArray[0];
                break;
            }
            case 4: {
                float[] fArray = new float[1];
                COM.MoveMemory(fArray, n + 8, 4);
                this.floatData = fArray[0];
                break;
            }
            case 5: {
                double[] dArray = new double[1];
                COM.MoveMemory(dArray, n + 8, 8);
                this.doubleData = dArray[0];
                break;
            }
            case 9: {
                int[] nArray = new int[1];
                OS.MoveMemory(nArray, n + 8, OS.PTR_SIZEOF);
                if (nArray[0] == 0) {
                    this.type = 0;
                    break;
                }
                this.dispatchData = new IDispatch(nArray[0]);
                this.dispatchData.AddRef();
                break;
            }
            case 13: {
                int[] nArray = new int[1];
                OS.MoveMemory(nArray, n + 8, OS.PTR_SIZEOF);
                if (nArray[0] == 0) {
                    this.type = 0;
                    break;
                }
                this.unknownData = new IUnknown(nArray[0]);
                this.unknownData.AddRef();
                break;
            }
            case 8: {
                int[] nArray = new int[1];
                OS.MoveMemory(nArray, n + 8, OS.PTR_SIZEOF);
                if (nArray[0] == 0) {
                    this.type = 0;
                    break;
                }
                int n2 = COM.SysStringByteLen(nArray[0]);
                if (n2 > 0) {
                    char[] cArray = new char[(n2 + 1) / 2];
                    COM.MoveMemory(cArray, nArray[0], n2);
                    this.stringData = new String(cArray);
                    break;
                }
                this.stringData = "";
                break;
            }
            default: {
                int n3 = OS.GlobalAlloc(64, sizeof);
                if (COM.VariantChangeType(n3, n, (short)0, (short)4) == 0) {
                    this.setData(n3);
                } else if (COM.VariantChangeType(n3, n, (short)0, (short)3) == 0) {
                    this.setData(n3);
                } else if (COM.VariantChangeType(n3, n, (short)0, (short)8) == 0) {
                    this.setData(n3);
                }
                COM.VariantClear(n3);
                OS.GlobalFree(n3);
            }
        }
    }

    public String toString() {
        switch (this.type) {
            case 11: {
                return "VT_BOOL{" + this.booleanData + "}";
            }
            case 16: {
                return "VT_I1{" + this.byteData + "}";
            }
            case 2: {
                return "VT_I2{" + this.shortData + "}";
            }
            case 18: {
                return "VT_UI2{" + this.charData + "}";
            }
            case 3: {
                return "VT_I4{" + this.intData + "}";
            }
            case 20: {
                return "VT_I8{" + this.longData + "}";
            }
            case 4: {
                return "VT_R4{" + this.floatData + "}";
            }
            case 5: {
                return "VT_R8{" + this.doubleData + "}";
            }
            case 8: {
                return "VT_BSTR{" + this.stringData + "}";
            }
            case 9: {
                return "VT_DISPATCH{" + (this.dispatchData == null ? 0 : this.dispatchData.getAddress()) + "}";
            }
            case 13: {
                return "VT_UNKNOWN{" + (this.unknownData == null ? 0 : this.unknownData.getAddress()) + "}";
            }
            case 0: {
                return "VT_EMPTY";
            }
            case 1: {
                return "VT_NULL";
            }
        }
        if ((this.type & 0x4000) != 0) {
            return "VT_BYREF|" + (this.type & 0xFFFFBFFF) + "{" + this.byRefPtr + "}";
        }
        return "Unsupported Type " + this.type;
    }
}

