/*
 * Decompiled with CFR 0.152.
 */
package org.clearsilver;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.TimeZone;
import org.clearsilver.CSFileLoader;
import org.clearsilver.HDF;

public abstract class DelegatedHdf
implements HDF {
    private final HDF hdf;

    public DelegatedHdf(HDF hdf) {
        if (hdf == null) {
            throw new NullPointerException("Null HDF is not allowed in constructor of DelegatedHdf.");
        }
        this.hdf = hdf;
    }

    public static HDF getFullyUnwrappedHdf(HDF hdf) {
        while (hdf instanceof DelegatedHdf) {
            hdf = ((DelegatedHdf)hdf).getHdf();
        }
        return hdf;
    }

    public HDF getHdf() {
        return this.hdf;
    }

    protected abstract DelegatedHdf newDelegatedHdf(HDF var1);

    public void close() {
        this.getHdf().close();
    }

    public boolean readFile(String filename) throws IOException, FileNotFoundException {
        return this.getHdf().readFile(filename);
    }

    public CSFileLoader getFileLoader() {
        return this.getHdf().getFileLoader();
    }

    public void setFileLoader(CSFileLoader fileLoader) {
        this.getHdf().setFileLoader(fileLoader);
    }

    public boolean writeFile(String filename) throws IOException {
        return this.getHdf().writeFile(filename);
    }

    public boolean readString(String data) {
        return this.getHdf().readString(data);
    }

    public String writeString() {
        return this.getHdf().writeString();
    }

    public int getIntValue(String hdfname, int default_value) {
        return this.getHdf().getIntValue(hdfname, default_value);
    }

    public String getValue(String hdfname, String default_value) {
        return this.getHdf().getValue(hdfname, default_value);
    }

    public void setValue(String hdfname, String value) {
        this.getHdf().setValue(hdfname, value);
    }

    public void removeTree(String hdfname) {
        this.getHdf().removeTree(hdfname);
    }

    public void setSymLink(String hdf_name_src, String hdf_name_dest) {
        this.getHdf().setSymLink(hdf_name_src, hdf_name_dest);
    }

    public void exportDate(String hdfname, TimeZone timeZone, Date date) {
        this.getHdf().exportDate(hdfname, timeZone, date);
    }

    public void exportDate(String hdfname, String tz, int tt) {
        this.getHdf().exportDate(hdfname, tz, tt);
    }

    public DelegatedHdf getObj(String hdfpath) {
        HDF hdf = this.getHdf().getObj(hdfpath);
        return hdf != null ? this.newDelegatedHdf(hdf) : null;
    }

    public DelegatedHdf getChild(String hdfpath) {
        HDF hdf = this.getHdf().getChild(hdfpath);
        return hdf != null ? this.newDelegatedHdf(hdf) : null;
    }

    public DelegatedHdf getRootObj() {
        HDF hdf = this.getHdf().getRootObj();
        return hdf != null ? this.newDelegatedHdf(hdf) : null;
    }

    public boolean belongsToSameRoot(HDF hdf) {
        return DelegatedHdf.getFullyUnwrappedHdf(this).belongsToSameRoot(DelegatedHdf.getFullyUnwrappedHdf(hdf));
    }

    public DelegatedHdf getOrCreateObj(String hdfpath) {
        HDF hdf = this.getHdf().getOrCreateObj(hdfpath);
        return hdf != null ? this.newDelegatedHdf(hdf) : null;
    }

    public String objName() {
        return this.getHdf().objName();
    }

    public String objValue() {
        return this.getHdf().objValue();
    }

    public DelegatedHdf objChild() {
        HDF hdf = this.getHdf().objChild();
        return hdf != null ? this.newDelegatedHdf(hdf) : null;
    }

    public DelegatedHdf objNext() {
        HDF hdf = this.getHdf().objNext();
        return hdf != null ? this.newDelegatedHdf(hdf) : null;
    }

    public void copy(String hdfpath, HDF src) {
        if (src != null && src instanceof DelegatedHdf) {
            src = ((DelegatedHdf)src).getHdf();
        }
        this.getHdf().copy(hdfpath, src);
    }

    public String dump() {
        return this.getHdf().dump();
    }
}

