/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.bidi.internal.consumable;

import org.eclipse.equinox.bidi.advanced.ISTextExpert;
import org.eclipse.equinox.bidi.custom.STextCharTypes;
import org.eclipse.equinox.bidi.custom.STextOffsets;
import org.eclipse.equinox.bidi.custom.STextTypeHandler;
import org.eclipse.equinox.bidi.internal.STextActivator;

public class STextJava
extends STextTypeHandler {
    private static final byte WS = 12;
    static final String lineSep = STextActivator.getInstance().getProperty("line.separator");
    private static final Integer STATE_SLASH_ASTER_COMMENT = new Integer(3);

    public STextJava() {
        super("[](){}.+-<>=~!&*/%^|?:,;\t");
    }

    public int getSpecialsCount(ISTextExpert expert) {
        return 4;
    }

    public int indexOfSpecial(ISTextExpert expert, String text, STextCharTypes charTypes, STextOffsets offsets, int caseNumber, int fromIndex) {
        switch (caseNumber) {
            case 1: {
                return text.indexOf(32, fromIndex);
            }
            case 2: {
                return text.indexOf(34, fromIndex);
            }
            case 3: {
                return text.indexOf("/*", fromIndex);
            }
            case 4: {
                return text.indexOf("//", fromIndex);
            }
        }
        return -1;
    }

    public int processSpecial(ISTextExpert expert, String text, STextCharTypes charTypes, STextOffsets offsets, int caseNumber, int separLocation) {
        STextTypeHandler.processSeparator(text, charTypes, offsets, separLocation);
        if (separLocation < 0) {
            caseNumber = (Integer)expert.getState();
            expert.clearState();
        }
        switch (caseNumber) {
            case 1: {
                ++separLocation;
                while (separLocation < text.length() && text.charAt(separLocation) == ' ') {
                    charTypes.setBidiTypeAt(separLocation, (byte)12);
                    ++separLocation;
                }
                return separLocation;
            }
            case 2: {
                int counter;
                int location = separLocation + 1;
                do {
                    if ((location = text.indexOf(34, location)) < 0) {
                        return text.length();
                    }
                    counter = 0;
                    int i = location - 1;
                    while (text.charAt(i) == '\\') {
                        ++counter;
                        --i;
                    }
                    ++location;
                } while ((counter & 1) != 0);
                return location;
            }
            case 3: {
                int location = separLocation < 0 ? 0 : separLocation + 2;
                location = text.indexOf("*/", location);
                if (location < 0) {
                    expert.setState(STATE_SLASH_ASTER_COMMENT);
                    return text.length();
                }
                STextTypeHandler.processSeparator(text, charTypes, offsets, location);
                return location + 2;
            }
            case 4: {
                int location = text.indexOf(lineSep, separLocation + 2);
                if (location < 0) {
                    return text.length();
                }
                return location + lineSep.length();
            }
        }
        return text.length();
    }
}

