/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.bidi.custom;

import org.eclipse.equinox.bidi.custom.STextCharTypes;

public class STextOffsets {
    private static final byte L = 0;
    private static final byte R = 1;
    private static final byte AL = 2;
    private static final byte AN = 6;
    private static final byte EN = 3;
    private static final byte[] STRONGS;
    private static final int OFFSET_SIZE = 20;
    private int[] offsets = new int[20];
    private int count;
    private int direction = -1;
    private int prefixLength;

    static {
        byte[] byArray = new byte[2];
        byArray[1] = 1;
        STRONGS = byArray;
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }

    public void setPrefixLength(int prefLen) {
        this.prefixLength = prefLen;
    }

    public int getCount() {
        return this.count;
    }

    public void clear() {
        this.count = 0;
    }

    public int getOffset(int index) {
        return this.offsets[index];
    }

    public void insertOffset(STextCharTypes charTypes, int offset) {
        int length;
        if (this.count >= this.offsets.length) {
            int[] newOffsets = new int[this.offsets.length * 2];
            System.arraycopy(this.offsets, 0, newOffsets, 0, this.count);
            this.offsets = newOffsets;
        }
        int index = this.count - 1;
        while (index >= 0) {
            int wrkOffset = this.offsets[index];
            if (offset > wrkOffset) break;
            if (offset == wrkOffset) {
                return;
            }
            --index;
        }
        if ((length = this.count - ++index) > 0) {
            System.arraycopy(this.offsets, index, this.offsets, index + 1, length);
        }
        this.offsets[index] = offset;
        ++this.count;
        if (offset < 1) {
            return;
        }
        if (charTypes == null) {
            return;
        }
        byte charType = charTypes.getBidiTypeAt(offset);
        index = charType == 0 || charType == 1 || charType == 2 || charType == 3 || charType == 6 ? offset - 1 : offset;
        if (this.direction < 0) {
            this.direction = charTypes.getDirection();
        }
        charTypes.setBidiTypeAt(index, STRONGS[this.direction]);
    }

    public int[] getOffsets() {
        if (this.count == this.offsets.length) {
            return this.offsets;
        }
        int[] array = new int[this.count];
        System.arraycopy(this.offsets, 0, array, 0, this.count);
        return array;
    }
}

