/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.obfuscate.AttributeUsageMarker;

public class ParameterNameMarker
extends SimplifiedVisitor
implements AttributeVisitor {
    private final AttributeVisitor attributeUsageMarker;

    public ParameterNameMarker(AttributeVisitor attributeVisitor) {
        this.attributeUsageMarker = attributeVisitor;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        if (!AttributeUsageMarker.isUsed(localVariableTableAttribute) && this.hasParameters(clazz, method)) {
            int n = 0;
            for (int i = 0; i < localVariableTableAttribute.u2localVariableTableLength; ++i) {
                LocalVariableInfo localVariableInfo = localVariableTableAttribute.localVariableTable[i];
                if (localVariableInfo.u2startPC != 0) continue;
                localVariableTableAttribute.localVariableTable[n++] = localVariableInfo;
            }
            localVariableTableAttribute.u2localVariableTableLength = n;
            if (n > 0) {
                this.attributeUsageMarker.visitLocalVariableTableAttribute(clazz, method, codeAttribute, localVariableTableAttribute);
            }
        }
    }

    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        if (!AttributeUsageMarker.isUsed(localVariableTypeTableAttribute) && this.hasParameters(clazz, method)) {
            int n = 0;
            for (int i = 0; i < localVariableTypeTableAttribute.u2localVariableTypeTableLength; ++i) {
                LocalVariableTypeInfo localVariableTypeInfo = localVariableTypeTableAttribute.localVariableTypeTable[i];
                if (localVariableTypeInfo.u2startPC != 0) continue;
                localVariableTypeTableAttribute.localVariableTypeTable[n++] = localVariableTypeInfo;
            }
            localVariableTypeTableAttribute.u2localVariableTypeTableLength = n;
            if (n > 0) {
                this.attributeUsageMarker.visitLocalVariableTypeTableAttribute(clazz, method, codeAttribute, localVariableTypeTableAttribute);
            }
        }
    }

    private boolean hasParameters(Clazz clazz, Method method) {
        return method.getDescriptor(clazz).charAt(1) != ')';
    }
}

