/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace;

import com.android.ide.eclipse.gltrace.GLProtoBuf;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class TraceFileWriter {
    private DataInputStream mInputStream;
    private DataOutputStream mOutputStream;
    private Thread mReceiverThread;
    private int mFileSize = 0;
    private int mFrameCount = 0;

    public TraceFileWriter(FileOutputStream fos, DataInputStream is) {
        this.mOutputStream = new DataOutputStream(fos);
        this.mInputStream = is;
    }

    public void start() {
        this.mReceiverThread = new Thread(new GLTraceReceiverTask());
        this.mReceiverThread.setName("GL Trace Receiver");
        this.mReceiverThread.start();
    }

    public void stopTracing() {
        try {
            this.mInputStream.close();
        }
        catch (IOException iOException) {}
        try {
            this.mReceiverThread.join();
        }
        catch (InterruptedException interruptedException) {}
        try {
            this.mOutputStream.close();
        }
        catch (IOException iOException) {}
    }

    private byte[] readTraceData(DataInputStream dis) {
        int read;
        int len;
        try {
            len = dis.readInt();
        }
        catch (IOException iOException) {
            return null;
        }
        len = Integer.reverseBytes(len);
        byte[] buffer = new byte[len];
        for (int readLen = 0; readLen < len; readLen += read) {
            block6: {
                try {
                    read = dis.read(buffer, readLen, len - readLen);
                    if (read >= 0) break block6;
                    return null;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            continue;
        }
        return buffer;
    }

    private void writeTraceData(byte[] buffer, DataOutputStream stream) throws IOException {
        stream.writeInt(buffer.length);
        stream.write(buffer);
    }

    private void updateTraceStats(byte[] buffer) {
        GLProtoBuf.GLMessage msg = null;
        try {
            msg = GLProtoBuf.GLMessage.parseFrom(buffer);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            return;
        }
        this.mFileSize += buffer.length;
        if (msg.getFunction() == GLProtoBuf.GLMessage.Function.eglSwapBuffers) {
            ++this.mFrameCount;
        }
    }

    public int getCurrentFileSize() {
        return this.mFileSize;
    }

    public int getCurrentFrameCount() {
        return this.mFrameCount;
    }

    private class GLTraceReceiverTask
    implements Runnable {
        private GLTraceReceiverTask() {
        }

        @Override
        public void run() {
            byte[] buffer;
            while ((buffer = TraceFileWriter.this.readTraceData(TraceFileWriter.this.mInputStream)) != null) {
                try {
                    TraceFileWriter.this.writeTraceData(buffer, TraceFileWriter.this.mOutputStream);
                }
                catch (IOException iOException) {
                    break;
                }
                TraceFileWriter.this.updateTraceStats(buffer);
            }
        }
    }
}

