/*
 * Decompiled with CFR 0.152.
 */
package com.android.jobb;

public class Base64 {
    private static final byte[] encodingTable;
    private static final byte[] decodingTable;

    public static byte[] encode(byte[] data) {
        int modulus = data.length % 3;
        byte[] bytes = modulus == 0 ? new byte[4 * data.length / 3] : new byte[4 * (data.length / 3 + 1)];
        int dataLength = data.length - modulus;
        int i = 0;
        int j = 0;
        while (i < dataLength) {
            int a1 = data[i] & 0xFF;
            int a2 = data[i + 1] & 0xFF;
            int a3 = data[i + 2] & 0xFF;
            bytes[j] = encodingTable[a1 >>> 2 & 0x3F];
            bytes[j + 1] = encodingTable[(a1 << 4 | a2 >>> 4) & 0x3F];
            bytes[j + 2] = encodingTable[(a2 << 2 | a3 >>> 6) & 0x3F];
            bytes[j + 3] = encodingTable[a3 & 0x3F];
            i += 3;
            j += 4;
        }
        switch (modulus) {
            case 0: {
                break;
            }
            case 1: {
                int d1 = data[data.length - 1] & 0xFF;
                int b1 = d1 >>> 2 & 0x3F;
                int b2 = d1 << 4 & 0x3F;
                bytes[bytes.length - 4] = encodingTable[b1];
                bytes[bytes.length - 3] = encodingTable[b2];
                bytes[bytes.length - 2] = 61;
                bytes[bytes.length - 1] = 61;
                break;
            }
            case 2: {
                int d1 = data[data.length - 2] & 0xFF;
                int d2 = data[data.length - 1] & 0xFF;
                int b1 = d1 >>> 2 & 0x3F;
                int b2 = (d1 << 4 | d2 >>> 4) & 0x3F;
                int b3 = d2 << 2 & 0x3F;
                bytes[bytes.length - 4] = encodingTable[b1];
                bytes[bytes.length - 3] = encodingTable[b2];
                bytes[bytes.length - 2] = encodingTable[b3];
                bytes[bytes.length - 1] = 61;
            }
        }
        return bytes;
    }

    public static byte[] decode(byte[] data) {
        byte b4;
        byte b3;
        byte b2;
        byte b1;
        byte[] bytes = data[data.length - 2] == 61 ? new byte[(data.length / 4 - 1) * 3 + 1] : (data[data.length - 1] == 61 ? new byte[(data.length / 4 - 1) * 3 + 2] : new byte[data.length / 4 * 3]);
        int i = 0;
        int j = 0;
        while (i < data.length - 4) {
            b1 = decodingTable[data[i]];
            b2 = decodingTable[data[i + 1]];
            b3 = decodingTable[data[i + 2]];
            b4 = decodingTable[data[i + 3]];
            bytes[j] = (byte)(b1 << 2 | b2 >> 4);
            bytes[j + 1] = (byte)(b2 << 4 | b3 >> 2);
            bytes[j + 2] = (byte)(b3 << 6 | b4);
            i += 4;
            j += 3;
        }
        if (data[data.length - 2] == 61) {
            b1 = decodingTable[data[data.length - 4]];
            b2 = decodingTable[data[data.length - 3]];
            bytes[bytes.length - 1] = (byte)(b1 << 2 | b2 >> 4);
        } else if (data[data.length - 1] == 61) {
            b1 = decodingTable[data[data.length - 4]];
            b2 = decodingTable[data[data.length - 3]];
            b3 = decodingTable[data[data.length - 2]];
            bytes[bytes.length - 2] = (byte)(b1 << 2 | b2 >> 4);
            bytes[bytes.length - 1] = (byte)(b2 << 4 | b3 >> 2);
        } else {
            b1 = decodingTable[data[data.length - 4]];
            b2 = decodingTable[data[data.length - 3]];
            b3 = decodingTable[data[data.length - 2]];
            b4 = decodingTable[data[data.length - 1]];
            bytes[bytes.length - 3] = (byte)(b1 << 2 | b2 >> 4);
            bytes[bytes.length - 2] = (byte)(b2 << 4 | b3 >> 2);
            bytes[bytes.length - 1] = (byte)(b3 << 6 | b4);
        }
        return bytes;
    }

    public static byte[] decode(String data) {
        byte b4;
        byte b3;
        byte b2;
        byte b1;
        byte[] bytes = data.charAt(data.length() - 2) == '=' ? new byte[(data.length() / 4 - 1) * 3 + 1] : (data.charAt(data.length() - 1) == '=' ? new byte[(data.length() / 4 - 1) * 3 + 2] : new byte[data.length() / 4 * 3]);
        int i = 0;
        int j = 0;
        while (i < data.length() - 4) {
            b1 = decodingTable[data.charAt(i)];
            b2 = decodingTable[data.charAt(i + 1)];
            b3 = decodingTable[data.charAt(i + 2)];
            b4 = decodingTable[data.charAt(i + 3)];
            bytes[j] = (byte)(b1 << 2 | b2 >> 4);
            bytes[j + 1] = (byte)(b2 << 4 | b3 >> 2);
            bytes[j + 2] = (byte)(b3 << 6 | b4);
            i += 4;
            j += 3;
        }
        if (data.charAt(data.length() - 2) == '=') {
            b1 = decodingTable[data.charAt(data.length() - 4)];
            b2 = decodingTable[data.charAt(data.length() - 3)];
            bytes[bytes.length - 1] = (byte)(b1 << 2 | b2 >> 4);
        } else if (data.charAt(data.length() - 1) == '=') {
            b1 = decodingTable[data.charAt(data.length() - 4)];
            b2 = decodingTable[data.charAt(data.length() - 3)];
            b3 = decodingTable[data.charAt(data.length() - 2)];
            bytes[bytes.length - 2] = (byte)(b1 << 2 | b2 >> 4);
            bytes[bytes.length - 1] = (byte)(b2 << 4 | b3 >> 2);
        } else {
            b1 = decodingTable[data.charAt(data.length() - 4)];
            b2 = decodingTable[data.charAt(data.length() - 3)];
            b3 = decodingTable[data.charAt(data.length() - 2)];
            b4 = decodingTable[data.charAt(data.length() - 1)];
            bytes[bytes.length - 3] = (byte)(b1 << 2 | b2 >> 4);
            bytes[bytes.length - 2] = (byte)(b2 << 4 | b3 >> 2);
            bytes[bytes.length - 1] = (byte)(b3 << 6 | b4);
        }
        return bytes;
    }

    static {
        int i;
        encodingTable = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        decodingTable = new byte[128];
        for (i = 65; i <= 90; ++i) {
            Base64.decodingTable[i] = (byte)(i - 65);
        }
        for (i = 97; i <= 122; ++i) {
            Base64.decodingTable[i] = (byte)(i - 97 + 26);
        }
        for (i = 48; i <= 57; ++i) {
            Base64.decodingTable[i] = (byte)(i - 48 + 52);
        }
        Base64.decodingTable[43] = 62;
        Base64.decodingTable[47] = 63;
    }
}

