/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCROLLINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TVITEM;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class TreeItem
extends Item {
    public long handle;
    Tree parent;
    String[] strings;
    Image[] images;
    Font font;
    Font[] cellFont;
    boolean cached;
    int background = -1;
    int foreground = -1;
    int[] cellBackground;
    int[] cellForeground;

    public TreeItem(Tree tree, int n) {
        this(tree, n, 0L, -65534L, 0L);
    }

    public TreeItem(Tree tree, int n, int n2) {
        this(tree, n, 0L, TreeItem.findPrevious(tree, n2), 0L);
    }

    public TreeItem(TreeItem treeItem, int n) {
        this(TreeItem.checkNull((TreeItem)treeItem).parent, n, treeItem.handle, -65534L, 0L);
    }

    public TreeItem(TreeItem treeItem, int n, int n2) {
        this(TreeItem.checkNull((TreeItem)treeItem).parent, n, treeItem.handle, TreeItem.findPrevious(treeItem, n2), 0L);
    }

    TreeItem(Tree tree, int n, long l, long l2, long l3) {
        super(tree, n);
        this.parent = tree;
        tree.createItem(this, l, l2, l3);
    }

    static TreeItem checkNull(TreeItem treeItem) {
        if (treeItem == null) {
            SWT.error(4);
        }
        return treeItem;
    }

    static long findPrevious(Tree tree, int n) {
        if (tree == null) {
            return 0L;
        }
        if (n < 0) {
            SWT.error(6);
        }
        if (n == 0) {
            return -65535L;
        }
        long l = tree.handle;
        long l2 = OS.SendMessage(l, 4362, 0L, 0L);
        long l3 = tree.findItem(l2, n - 1);
        if (l3 == 0L) {
            SWT.error(6);
        }
        return l3;
    }

    static long findPrevious(TreeItem treeItem, int n) {
        if (treeItem == null) {
            return 0L;
        }
        if (n < 0) {
            SWT.error(6);
        }
        if (n == 0) {
            return -65535L;
        }
        Tree tree = treeItem.parent;
        long l = tree.handle;
        long l2 = treeItem.handle;
        long l3 = OS.SendMessage(l, 4362, 4L, l2);
        long l4 = tree.findItem(l3, n - 1);
        if (l4 == 0L) {
            SWT.error(6);
        }
        return l4;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clear() {
        this.text = "";
        this.image = null;
        this.strings = null;
        this.images = null;
        if ((this.parent.style & 0x20) != 0) {
            long l = this.parent.handle;
            TVITEM tVITEM = new TVITEM();
            tVITEM.mask = 24;
            tVITEM.stateMask = 61440;
            tVITEM.state = 4096;
            tVITEM.hItem = this.handle;
            OS.SendMessage(l, OS.TVM_SETITEM, 0L, tVITEM);
        }
        this.foreground = -1;
        this.background = -1;
        this.font = null;
        this.cellForeground = null;
        this.cellBackground = null;
        this.cellFont = null;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = false;
        }
    }

    public void clear(int n, boolean bl) {
        this.checkWidget();
        long l = this.parent.handle;
        long l2 = OS.SendMessage(l, 4362, 4L, this.handle);
        if (l2 == 0L) {
            this.error(6);
        }
        if ((l2 = this.parent.findItem(l2, n)) == 0L) {
            this.error(6);
        }
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 20;
        this.parent.clear(l2, tVITEM);
        if (bl) {
            l2 = OS.SendMessage(l, 4362, 4L, l2);
            this.parent.clearAll(l2, tVITEM, bl);
        }
    }

    public void clearAll(boolean bl) {
        this.checkWidget();
        long l = this.parent.handle;
        long l2 = OS.SendMessage(l, 4362, 4L, this.handle);
        if (l2 == 0L) {
            return;
        }
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 20;
        this.parent.clearAll(l2, tVITEM, bl);
    }

    void destroyWidget() {
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 20;
        this.parent.releaseItem(this.handle, tVITEM, false);
        this.parent.destroyItem(this, this.handle);
        this.releaseHandle();
    }

    long fontHandle(int n) {
        if (this.cellFont != null && this.cellFont[n] != null) {
            return this.cellFont[n].handle;
        }
        if (this.font != null) {
            return this.font.handle;
        }
        return -1L;
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (this.background == -1) {
            return this.parent.getBackground();
        }
        return Color.win32_new(this.display, this.background);
    }

    public Color getBackground(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return this.getBackground();
        }
        int n3 = this.cellBackground != null ? this.cellBackground[n] : -1;
        return n3 == -1 ? this.getBackground() : Color.win32_new(this.display, n3);
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        RECT rECT = this.getBounds(0, true, false, false);
        int n = rECT.right - rECT.left;
        int n2 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n, n2);
    }

    public Rectangle getBounds(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        RECT rECT = this.getBounds(n, true, true, true);
        int n2 = rECT.right - rECT.left;
        int n3 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n2, n3);
    }

    RECT getBounds(int n, boolean bl, boolean bl2, boolean bl3) {
        return this.getBounds(n, bl, bl2, bl3, false, true, 0L);
    }

    RECT getBounds(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, long l) {
        int n2;
        if (!bl && !bl2) {
            return new RECT();
        }
        long l2 = this.parent.handle;
        if ((this.parent.style & 0x10000000) == 0 && !this.cached && !this.parent.painted) {
            TVITEM tVITEM = new TVITEM();
            tVITEM.mask = 17;
            tVITEM.hItem = this.handle;
            tVITEM.pszText = -1L;
            this.parent.ignoreCustomDraw = true;
            OS.SendMessage(l2, OS.TVM_SETITEM, 0L, tVITEM);
            this.parent.ignoreCustomDraw = false;
        }
        boolean bl6 = n == 0;
        int n3 = 0;
        long l3 = this.parent.hwndHeader;
        if (l3 != 0L) {
            n3 = this.parent.columnCount;
            bl6 = (long)n == OS.SendMessage(l3, 4623, 0L, 0L);
        }
        RECT rECT = new RECT();
        if (bl6) {
            Object object;
            n2 = n3 == 0 && bl && bl2 && bl3 && bl4 ? 1 : 0;
            if (!OS.TreeView_GetItemRect(l2, this.handle, rECT, n2 == 0)) {
                return new RECT();
            }
            if (bl2 && !bl4) {
                if (OS.SendMessage(l2, 4360, 0L, 0L) != 0L) {
                    object = this.parent.getImageSize();
                    rECT.left -= ((Point)object).x + 3;
                    if (!bl) {
                        rECT.right = rECT.left + ((Point)object).x;
                    }
                } else if (!bl) {
                    rECT.right = rECT.left;
                }
            }
            if ((bl3 || bl4 || bl5) && l3 != 0L) {
                object = new RECT();
                if (n3 != 0) {
                    if (OS.SendMessage(l3, 4615, (long)n, (RECT)object) == 0L) {
                        return new RECT();
                    }
                } else {
                    ((RECT)object).right = this.parent.scrollWidth;
                    if (((RECT)object).right == 0) {
                        object = rECT;
                    }
                }
                if (bl3 && bl5) {
                    rECT.right = ((RECT)object).right;
                }
                if (bl4) {
                    rECT.left = ((RECT)object).left;
                }
                if (bl5 && ((RECT)object).right < rECT.right) {
                    rECT.right = ((RECT)object).right;
                }
            }
        } else {
            if (n < 0 || n >= n3) {
                return new RECT();
            }
            RECT rECT2 = new RECT();
            if (OS.SendMessage(l3, 4615, (long)n, rECT2) == 0L) {
                return new RECT();
            }
            if (!OS.TreeView_GetItemRect(l2, this.handle, rECT, false)) {
                return new RECT();
            }
            rECT.left = rECT2.left;
            if (bl3 && bl2 && bl5) {
                rECT.right = rECT2.right;
            } else {
                Object object;
                rECT.right = rECT2.left;
                Image image = null;
                if (n == 0) {
                    image = this.image;
                } else if (this.images != null) {
                    image = this.images[n];
                }
                if (image != null) {
                    object = this.parent.getImageSize();
                    rECT.right += ((Point)object).x;
                }
                if (bl) {
                    if (bl3 && bl5) {
                        rECT.left = rECT.right + 3;
                        rECT.right = rECT2.right;
                    } else {
                        Object object2 = n == 0 ? this.text : (object = this.strings != null ? this.strings[n] : null);
                        if (object != null) {
                            RECT rECT3 = new RECT();
                            TCHAR tCHAR = new TCHAR(this.parent.getCodePage(), (String)object, false);
                            int n4 = 3104;
                            long l4 = l;
                            long l5 = 0L;
                            if (l == 0L) {
                                l4 = OS.GetDC(l2);
                                l5 = this.fontHandle(n);
                                if (l5 == -1L) {
                                    l5 = OS.SendMessage(l2, 49, 0L, 0L);
                                }
                                l5 = OS.SelectObject(l4, l5);
                            }
                            OS.DrawText(l4, tCHAR, tCHAR.length(), rECT3, n4);
                            if (l == 0L) {
                                OS.SelectObject(l4, l5);
                                OS.ReleaseDC(l2, l4);
                            }
                            if (bl2) {
                                rECT.right += rECT3.right - rECT3.left + 9;
                            } else {
                                rECT.left = rECT.right + 3;
                                rECT.right = rECT.left + (rECT3.right - rECT3.left) + 3;
                            }
                        }
                    }
                }
                if (bl5 && rECT2.right < rECT.right) {
                    rECT.right = rECT2.right;
                }
            }
        }
        int n5 = n2 = this.parent.linesVisible && n3 != 0 ? 1 : 0;
        if (bl || !bl2) {
            rECT.right = Math.max(rECT.left, rECT.right - n2);
        }
        rECT.bottom = Math.max(rECT.top, rECT.bottom - n2);
        return rECT;
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        long l = this.parent.handle;
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 24;
        tVITEM.stateMask = 61440;
        tVITEM.hItem = this.handle;
        long l2 = OS.SendMessage(l, OS.TVM_GETITEM, 0L, tVITEM);
        return l2 != 0L && (tVITEM.state >> 12 & 1) == 0;
    }

    public boolean getExpanded() {
        this.checkWidget();
        long l = this.parent.handle;
        int n = 0;
        if (OS.IsWinCE) {
            TVITEM tVITEM = new TVITEM();
            tVITEM.hItem = this.handle;
            tVITEM.mask = 8;
            OS.SendMessage(l, OS.TVM_GETITEM, 0L, tVITEM);
            n = tVITEM.state;
        } else {
            n = (int)OS.SendMessage(l, 4391, this.handle, 32L);
        }
        return (n & 0x20) != 0;
    }

    public Font getFont() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.font != null ? this.font : this.parent.getFont();
    }

    public Font getFont(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return this.getFont();
        }
        if (this.cellFont == null || this.cellFont[n] == null) {
            return this.getFont();
        }
        return this.cellFont[n];
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (this.foreground == -1) {
            return this.parent.getForeground();
        }
        return Color.win32_new(this.display, this.foreground);
    }

    public Color getForeground(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return this.getForeground();
        }
        int n3 = this.cellForeground != null ? this.cellForeground[n] : -1;
        return n3 == -1 ? this.getForeground() : Color.win32_new(this.display, n3);
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        long l = this.parent.handle;
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 24;
        tVITEM.stateMask = 61440;
        tVITEM.hItem = this.handle;
        long l2 = OS.SendMessage(l, OS.TVM_GETITEM, 0L, tVITEM);
        return l2 != 0L && tVITEM.state >> 12 > 2;
    }

    public TreeItem getItem(int n) {
        long l;
        long l2;
        long l3;
        this.checkWidget();
        if (n < 0) {
            this.error(6);
        }
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((l3 = OS.SendMessage(l2 = this.parent.handle, 4362, 4L, this.handle)) == 0L) {
            this.error(6);
        }
        if ((l = this.parent.findItem(l3, n)) == 0L) {
            this.error(6);
        }
        return this.parent._getItem(l);
    }

    public int getItemCount() {
        long l;
        long l2;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((l2 = OS.SendMessage(l = this.parent.handle, 4362, 4L, this.handle)) == 0L) {
            return 0;
        }
        return this.parent.getItemCount(l2);
    }

    public TreeItem[] getItems() {
        long l;
        long l2;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((l2 = OS.SendMessage(l = this.parent.handle, 4362, 4L, this.handle)) == 0L) {
            return new TreeItem[0];
        }
        return this.parent.getItems(l2);
    }

    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getImage();
    }

    public Image getImage(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (n == 0) {
            return this.getImage();
        }
        if (this.images != null && n >= 0 && n < this.images.length) {
            return this.images[n];
        }
        return null;
    }

    public Rectangle getImageBounds(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        RECT rECT = this.getBounds(n, false, true, false);
        int n2 = rECT.right - rECT.left;
        int n3 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n2, n3);
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        long l = this.parent.handle;
        long l2 = OS.SendMessage(l, 4362, 3L, this.handle);
        return l2 != 0L ? this.parent._getItem(l2) : null;
    }

    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getText();
    }

    public String getText(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (n == 0) {
            return this.getText();
        }
        if (this.strings != null && n >= 0 && n < this.strings.length) {
            String string = this.strings[n];
            return string != null ? string : "";
        }
        return "";
    }

    public Rectangle getTextBounds(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        RECT rECT = this.getBounds(n, true, false, true);
        if (n == 0) {
            rECT.left += 2;
        }
        rECT.left = Math.min(rECT.left, rECT.right);
        rECT.right -= 3;
        int n2 = Math.max(0, rECT.right - rECT.left);
        int n3 = Math.max(0, rECT.bottom - rECT.top);
        return new Rectangle(rECT.left, rECT.top, n2, n3);
    }

    public int indexOf(TreeItem treeItem) {
        long l;
        long l2;
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        return (l2 = OS.SendMessage(l = this.parent.handle, 4362, 4L, this.handle)) == 0L ? -1 : this.parent.findIndex(l2, treeItem.handle);
    }

    void redraw() {
        RECT rECT;
        boolean bl;
        if (this.parent.currentItem == this || !this.parent.getDrawing()) {
            return;
        }
        long l = this.parent.handle;
        if (!OS.IsWindowVisible(l)) {
            return;
        }
        boolean bl2 = bl = (this.parent.style & 0x10010000) != 0;
        if (!bl) {
            boolean bl3 = bl = this.parent.columnCount != 0;
            if (!bl && (this.parent.hooks(40) || this.parent.hooks(42))) {
                bl = true;
            }
        }
        if (OS.TreeView_GetItemRect(l, this.handle, rECT = new RECT(), !bl)) {
            OS.InvalidateRect(l, rECT, true);
        }
    }

    void redraw(int n, boolean bl, boolean bl2) {
        if (this.parent.currentItem == this || !this.parent.getDrawing()) {
            return;
        }
        long l = this.parent.handle;
        if (!OS.IsWindowVisible(l)) {
            return;
        }
        boolean bl3 = n == 0 && bl && bl2;
        RECT rECT = this.getBounds(n, bl, bl2, true, bl3, true, 0L);
        OS.InvalidateRect(l, rECT, true);
    }

    void releaseChildren(boolean bl) {
        if (bl) {
            TVITEM tVITEM = new TVITEM();
            tVITEM.mask = 20;
            this.parent.releaseItems(this.handle, tVITEM);
        }
        super.releaseChildren(bl);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.handle = 0L;
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.strings = null;
        this.images = null;
        this.cellForeground = null;
        this.cellBackground = null;
        this.cellFont = null;
    }

    public void removeAll() {
        this.checkWidget();
        long l = this.parent.handle;
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 20;
        tVITEM.hItem = OS.SendMessage(l, 4362, 4L, this.handle);
        while (tVITEM.hItem != 0L) {
            Widget widget;
            OS.SendMessage(l, OS.TVM_GETITEM, 0L, tVITEM);
            Widget widget2 = widget = tVITEM.lParam != -1L ? this.parent.items[(int)tVITEM.lParam] : null;
            if (widget != null && !widget.isDisposed()) {
                widget.dispose();
            } else {
                this.parent.releaseItem(tVITEM.hItem, tVITEM, false);
                this.parent.destroyItem(null, tVITEM.hItem);
            }
            tVITEM.hItem = OS.SendMessage(l, 4362, 4L, this.handle);
        }
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n = -1;
        if (color != null) {
            this.parent.customDraw = true;
            n = color.handle;
        }
        if (this.background == n) {
            return;
        }
        this.background = n;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redraw();
    }

    public void setBackground(int n, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return;
        }
        int n3 = -1;
        if (color != null) {
            this.parent.customDraw = true;
            n3 = color.handle;
        }
        if (this.cellBackground == null) {
            this.cellBackground = new int[n2];
            int n4 = 0;
            while (n4 < n2) {
                this.cellBackground[n4] = -1;
                ++n4;
            }
        }
        if (this.cellBackground[n] == n3) {
            return;
        }
        this.cellBackground[n] = n3;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redraw(n, true, true);
    }

    public void setChecked(boolean bl) {
        RECT rECT;
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        long l = this.parent.handle;
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 24;
        tVITEM.stateMask = 61440;
        tVITEM.hItem = this.handle;
        OS.SendMessage(l, OS.TVM_GETITEM, 0L, tVITEM);
        int n = tVITEM.state >> 12;
        if (bl) {
            if ((n & 1) != 0) {
                ++n;
            }
        } else if ((n & 1) == 0) {
            --n;
        }
        if (tVITEM.state == (n <<= 12)) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        tVITEM.state = n;
        OS.SendMessage(l, OS.TVM_SETITEM, 0L, tVITEM);
        if ((this.parent.style & 0x10000000) != 0 && this.parent.currentItem == this && OS.IsWindowVisible(l) && OS.TreeView_GetItemRect(l, this.handle, rECT = new RECT(), false)) {
            OS.InvalidateRect(l, rECT, true);
        }
    }

    public void setExpanded(boolean bl) {
        long l;
        Object object;
        Object object2;
        this.checkWidget();
        long l2 = this.parent.handle;
        if (OS.SendMessage(l2, 4362, 4L, this.handle) == 0L) {
            return;
        }
        int n = 0;
        if (OS.IsWinCE) {
            object2 = new TVITEM();
            ((TVITEM)object2).hItem = this.handle;
            ((TVITEM)object2).mask = 8;
            OS.SendMessage(l2, OS.TVM_GETITEM, 0L, (TVITEM)object2);
            n = ((TVITEM)object2).state;
        } else {
            n = (int)OS.SendMessage(l2, 4391, this.handle, 32L);
        }
        if ((n & 0x20) != 0 == bl) {
            return;
        }
        object2 = null;
        RECT[] rECTArray = null;
        SCROLLINFO sCROLLINFO = null;
        int n2 = 0;
        long l3 = 0L;
        boolean bl2 = false;
        boolean bl3 = true;
        long l4 = OS.SendMessage(l2, 4362, 5L, 0L);
        if (bl3 && l4 != 0L) {
            sCROLLINFO = new SCROLLINFO();
            sCROLLINFO.cbSize = SCROLLINFO.sizeof;
            sCROLLINFO.fMask = 23;
            if (!OS.GetScrollInfo(l2, 0, sCROLLINFO)) {
                sCROLLINFO = null;
            }
            if (this.parent.getDrawing() && OS.IsWindowVisible(l2)) {
                boolean bl4 = true;
                n2 = (int)OS.SendMessage(l2, 4368, 0L, 0L);
                rECTArray = new RECT[n2 + 1];
                long l5 = l4;
                int n3 = 0;
                while (l5 != 0L && (bl4 || l5 != this.handle) && n3 < n2) {
                    object = new RECT();
                    if (OS.TreeView_GetItemRect(l2, l5, (RECT)object, true)) {
                        rECTArray[n3++] = object;
                    }
                    l5 = OS.SendMessage(l2, 4362, 6L, l5);
                }
                if (bl4 || l5 != this.handle) {
                    bl2 = true;
                    n2 = n3;
                    l3 = l5;
                    object2 = new RECT();
                    OS.GetClientRect(l2, (RECT)object2);
                    long l6 = this.parent.topHandle();
                    OS.UpdateWindow(l6);
                    OS.DefWindowProc(l6, 11, 0L, 0L);
                    if (l2 != l6) {
                        OS.UpdateWindow(l2);
                        OS.DefWindowProc(l2, 11, 0L, 0L);
                    }
                }
            }
        }
        long l7 = OS.SendMessage(l2, 4362, 9L, 0L);
        this.parent.ignoreExpand = true;
        OS.SendMessage(l2, 4354, (long)(bl ? 2 : 1), this.handle);
        this.parent.ignoreExpand = false;
        if (bl3 && l4 != 0L) {
            long l8;
            boolean bl5 = false;
            if (!bl) {
                RECT rECT = new RECT();
                while (l4 != 0L && !OS.TreeView_GetItemRect(l2, l4, rECT, false)) {
                    l4 = OS.SendMessage(l2, 4362, 3L, l4);
                    bl5 = true;
                }
            }
            boolean bl6 = true;
            if (l4 != 0L) {
                OS.SendMessage(l2, 4363, 5L, l4);
                boolean bl7 = bl6 = l4 != OS.SendMessage(l2, 4362, 5L, 0L);
            }
            if (!bl5 && !bl6 && sCROLLINFO != null) {
                object = new SCROLLINFO();
                ((SCROLLINFO)object).cbSize = SCROLLINFO.sizeof;
                ((SCROLLINFO)object).fMask = 23;
                if (OS.GetScrollInfo(l2, 0, (SCROLLINFO)object) && sCROLLINFO.nPos != ((SCROLLINFO)object).nPos) {
                    l8 = OS.MAKELPARAM(4, sCROLLINFO.nPos);
                    OS.SendMessage(l2, 276, l8, 0L);
                }
            }
            if (bl2) {
                boolean bl8 = false;
                if (!bl5 && !bl6) {
                    RECT rECT = new RECT();
                    OS.GetClientRect(l2, rECT);
                    if (OS.EqualRect((RECT)object2, rECT)) {
                        long l9 = l4;
                        int n4 = 0;
                        while (l9 != 0L && n4 < n2) {
                            RECT rECT2 = new RECT();
                            if (OS.TreeView_GetItemRect(l2, l9, rECT2, true) && !OS.EqualRect(rECT2, rECTArray[n4])) break;
                            l9 = OS.SendMessage(l2, 4362, 6L, l9);
                            ++n4;
                        }
                        bl8 = n4 == n2 && l9 == l3;
                    }
                }
                l8 = this.parent.topHandle();
                OS.DefWindowProc(l8, 11, 1L, 0L);
                if (l2 != l8) {
                    OS.DefWindowProc(l2, 11, 1L, 0L);
                }
                if (bl8) {
                    RECT rECT;
                    this.parent.updateScrollBar();
                    SCROLLINFO sCROLLINFO2 = new SCROLLINFO();
                    sCROLLINFO2.cbSize = SCROLLINFO.sizeof;
                    sCROLLINFO2.fMask = 23;
                    if (OS.GetScrollInfo(l2, 1, sCROLLINFO2)) {
                        OS.SetScrollInfo(l2, 1, sCROLLINFO2, true);
                    }
                    if (this.handle == l3 && OS.TreeView_GetItemRect(l2, l3, rECT = new RECT(), false)) {
                        OS.InvalidateRect(l2, rECT, true);
                    }
                } else if (OS.IsWinCE) {
                    OS.InvalidateRect(l8, null, true);
                    if (l2 != l8) {
                        OS.InvalidateRect(l2, null, true);
                    }
                } else {
                    int n5 = 1157;
                    OS.RedrawWindow(l8, null, 0L, n5);
                }
            }
        }
        if ((l = OS.SendMessage(l2, 4362, 9L, 0L)) != l7) {
            Event event = new Event();
            if (l != 0L) {
                event.item = this.parent._getItem(l);
                this.parent.hAnchor = l;
            }
            this.parent.sendEvent(13, event);
        }
    }

    public void setFont(Font font) {
        Font font2;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((font2 = this.font) == font) {
            return;
        }
        this.font = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        if (font != null) {
            this.parent.customDraw = true;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if ((this.parent.style & 0x10000000) == 0 && !this.cached && !this.parent.painted) {
            return;
        }
        long l = this.parent.handle;
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 17;
        tVITEM.hItem = this.handle;
        tVITEM.pszText = -1L;
        OS.SendMessage(l, OS.TVM_SETITEM, 0L, tVITEM);
    }

    public void setFont(int n, Font font) {
        Font font2;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return;
        }
        if (this.cellFont == null) {
            if (font == null) {
                return;
            }
            this.cellFont = new Font[n2];
        }
        if ((font2 = this.cellFont[n]) == font) {
            return;
        }
        this.cellFont[n] = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        if (font != null) {
            this.parent.customDraw = true;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (n == 0) {
            if ((this.parent.style & 0x10000000) == 0 && !this.cached && !this.parent.painted) {
                return;
            }
            long l = this.parent.handle;
            TVITEM tVITEM = new TVITEM();
            tVITEM.mask = 17;
            tVITEM.hItem = this.handle;
            tVITEM.pszText = -1L;
            OS.SendMessage(l, OS.TVM_SETITEM, 0L, tVITEM);
        } else {
            this.redraw(n, true, false);
        }
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n = -1;
        if (color != null) {
            this.parent.customDraw = true;
            n = color.handle;
        }
        if (this.foreground == n) {
            return;
        }
        this.foreground = n;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redraw();
    }

    public void setForeground(int n, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return;
        }
        int n3 = -1;
        if (color != null) {
            this.parent.customDraw = true;
            n3 = color.handle;
        }
        if (this.cellForeground == null) {
            this.cellForeground = new int[n2];
            int n4 = 0;
            while (n4 < n2) {
                this.cellForeground[n4] = -1;
                ++n4;
            }
        }
        if (this.cellForeground[n] == n3) {
            return;
        }
        this.cellForeground[n] = n3;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redraw(n, true, false);
    }

    public void setGrayed(boolean bl) {
        RECT rECT;
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        long l = this.parent.handle;
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 24;
        tVITEM.stateMask = 61440;
        tVITEM.hItem = this.handle;
        OS.SendMessage(l, OS.TVM_GETITEM, 0L, tVITEM);
        int n = tVITEM.state >> 12;
        if (bl) {
            if (n <= 2) {
                n += 2;
            }
        } else if (n > 2) {
            n -= 2;
        }
        if (tVITEM.state == (n <<= 12)) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        tVITEM.state = n;
        OS.SendMessage(l, OS.TVM_SETITEM, 0L, tVITEM);
        if ((this.parent.style & 0x10000000) != 0 && this.parent.currentItem == this && OS.IsWindowVisible(l) && OS.TreeView_GetItemRect(l, this.handle, rECT = new RECT(), false)) {
            OS.InvalidateRect(l, rECT, true);
        }
    }

    public void setImage(Image[] imageArray) {
        this.checkWidget();
        if (imageArray == null) {
            this.error(4);
        }
        int n = 0;
        while (n < imageArray.length) {
            this.setImage(n, imageArray[n]);
            ++n;
        }
    }

    public void setImage(int n, Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        Image image2 = null;
        if (n == 0) {
            if (image != null && image.type == 1 && image.equals(this.image)) {
                return;
            }
            image2 = this.image;
            super.setImage(image);
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return;
        }
        if (this.images == null && n != 0) {
            this.images = new Image[n2];
            this.images[0] = image;
        }
        if (this.images != null) {
            if (image != null && image.type == 1 && image.equals(this.images[n])) {
                return;
            }
            image2 = this.images[n];
            this.images[n] = image;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.parent.imageIndex(image, n);
        if (n == 0) {
            if ((this.parent.style & 0x10000000) == 0 && !this.cached && !this.parent.painted) {
                return;
            }
            long l = this.parent.handle;
            TVITEM tVITEM = new TVITEM();
            tVITEM.mask = 50;
            tVITEM.hItem = this.handle;
            tVITEM.iSelectedImage = -1;
            tVITEM.iImage = -1;
            tVITEM.mask |= 1;
            tVITEM.pszText = -1L;
            OS.SendMessage(l, OS.TVM_SETITEM, 0L, tVITEM);
        } else {
            boolean bl = image == null && image2 != null || image != null && image2 == null;
            this.redraw(n, bl, true);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setItemCount(int n) {
        this.checkWidget();
        n = Math.max(0, n);
        long l = this.parent.handle;
        long l2 = OS.SendMessage(l, 4362, 4L, this.handle);
        this.parent.setItemCount(n, this.handle, l2);
    }

    public void setText(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string != null) {
                this.setText(n, string);
            }
            ++n;
        }
    }

    public void setText(int n, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (n == 0) {
            if (string.equals(this.text)) {
                return;
            }
            super.setText(string);
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return;
        }
        if (this.strings == null && n != 0) {
            this.strings = new String[n2];
            this.strings[0] = this.text;
        }
        if (this.strings != null) {
            if (string.equals(this.strings[n])) {
                return;
            }
            this.strings[n] = string;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (n == 0) {
            if ((this.parent.style & 0x10000000) == 0 && !this.cached && !this.parent.painted) {
                return;
            }
            long l = this.parent.handle;
            TVITEM tVITEM = new TVITEM();
            tVITEM.mask = 17;
            tVITEM.hItem = this.handle;
            tVITEM.pszText = -1L;
            OS.SendMessage(l, OS.TVM_SETITEM, 0L, tVITEM);
        } else {
            this.redraw(n, true, false);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }

    void sort() {
        this.checkWidget();
        if ((this.parent.style & 0x10000000) != 0) {
            return;
        }
        this.parent.sort(this.handle, false);
    }
}

