/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.ui;

import com.android.ddmuilib.ImageLoader;
import com.android.hierarchyviewerlib.models.PixelPerfectModel;
import com.android.hierarchyviewerlib.models.ViewNode;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class PixelPerfectTree
extends Composite
implements PixelPerfectModel.IImageChangeListener,
SelectionListener {
    private TreeViewer mTreeViewer;
    private Tree mTree;
    private PixelPerfectModel mModel;
    private Image mFolderImage;
    private Image mFileImage;
    private DisposeListener mDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            PixelPerfectTree.this.mModel.removeImageChangeListener(PixelPerfectTree.this);
        }
    };

    public PixelPerfectTree(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.mTreeViewer = new TreeViewer(this, 4);
        this.mTreeViewer.setAutoExpandLevel(-1);
        this.mTree = this.mTreeViewer.getTree();
        this.mTree.addSelectionListener((SelectionListener)this);
        this.loadResources();
        this.addDisposeListener(this.mDisposeListener);
        this.mModel = PixelPerfectModel.getModel();
        ContentProvider contentProvider = new ContentProvider();
        this.mTreeViewer.setContentProvider(contentProvider);
        this.mTreeViewer.setLabelProvider(contentProvider);
        this.mTreeViewer.setInput(this.mModel);
        this.mModel.addImageChangeListener(this);
    }

    private void loadResources() {
        ImageLoader loader = ImageLoader.getDdmUiLibLoader();
        this.mFileImage = loader.loadImage("file.png", Display.getDefault());
        this.mFolderImage = loader.loadImage("folder.png", Display.getDefault());
    }

    public boolean setFocus() {
        return this.mTree.setFocus();
    }

    @Override
    public void imageLoaded() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                PixelPerfectTree.this.mTreeViewer.refresh();
                PixelPerfectTree.this.mTreeViewer.expandAll();
            }
        });
    }

    @Override
    public void imageChanged() {
    }

    @Override
    public void crosshairMoved() {
    }

    @Override
    public void selectionChanged() {
    }

    @Override
    public void treeChanged() {
        this.imageLoaded();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (((TreeSelection)this.mTreeViewer.getSelection()).isEmpty()) {
            this.mModel.setSelected(null);
        } else {
            this.mModel.setSelected((ViewNode)e.item.getData());
        }
    }

    @Override
    public void zoomChanged() {
    }

    @Override
    public void overlayChanged() {
    }

    @Override
    public void overlayTransparencyChanged() {
    }

    private class ContentProvider
    implements ITreeContentProvider,
    ILabelProvider {
        private ContentProvider() {
        }

        @Override
        public Object[] getChildren(Object element) {
            if (element instanceof ViewNode) {
                List<ViewNode> children = ((ViewNode)element).children;
                return children.toArray(new ViewNode[children.size()]);
            }
            return null;
        }

        @Override
        public Object getParent(Object element) {
            if (element instanceof ViewNode) {
                return ((ViewNode)element).parent;
            }
            return null;
        }

        @Override
        public boolean hasChildren(Object element) {
            if (element instanceof ViewNode) {
                return ((ViewNode)element).children.size() != 0;
            }
            return false;
        }

        @Override
        public Object[] getElements(Object element) {
            if (element instanceof PixelPerfectModel) {
                ViewNode viewNode = ((PixelPerfectModel)element).getViewNode();
                if (viewNode == null) {
                    return new Object[0];
                }
                return new Object[]{viewNode};
            }
            return new Object[0];
        }

        @Override
        public void dispose() {
        }

        @Override
        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        @Override
        public Image getImage(Object element) {
            if (element instanceof ViewNode) {
                if (this.hasChildren(element)) {
                    return PixelPerfectTree.this.mFolderImage;
                }
                return PixelPerfectTree.this.mFileImage;
            }
            return null;
        }

        @Override
        public String getText(Object element) {
            if (element instanceof ViewNode) {
                return ((ViewNode)element).name;
            }
            return null;
        }

        @Override
        public void addListener(ILabelProviderListener listener) {
        }

        @Override
        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        @Override
        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

